import sys
from Bio import SeqIO

library = sys.argv[1]

counter = 0
sequences = set()
filename = "%s.1.fastq" % library
print("Reading", filename)
handle = open(filename)
records = SeqIO.parse(handle, "fastq")
n = 0
for record in records:
    seq = str(record.seq)
    sequences.add(seq)
    n += 1
handle.close()
print("%d lines read; %d unique sequences" % (n, len(sequences)))

sequences = sorted(sequences)
# Iterating over a set will not return the sequences in the order in which
# they were added to the set; the order will even change between Python runs
# because the hash algorithm changes. Sort the sequences here to guarantee a
# consistent result between runs.

filename = "%s.fa" % library
print("Writing %s" % filename)
output = open(filename, 'w')
for i, sequence in enumerate(sequences):
    output.write(">%s_%d\n" % (library, i))
    output.write("%s\n" % sequence)
output.close()
